# Print identifiers of sibling packages required by given package.
# USAGE: dependencies_siblings_list $package
dependencies_siblings_list() {
	local package
	package="$1"

	local dependencies_siblings
	dependencies_siblings=$(context_value "${package}_DEPENDENCIES_SIBLINGS")

	# Try to find a fallback value based on the package identifier:
	# current package → fallback package
	# PKG_BIN64       → PKG_BIN
	# PKG_BIN32       → PKG_BIN
	# PKG_LIBS64      → PKG_LIBS
	# PKG_LIBS32      → PKG_LIBS
	# PKG_L10N_xxx    → PKG_L10N
	if [ -z "$dependencies_siblings" ]; then
		case "$package" in
			('PKG_BIN64'|'PKG_BIN32')
				dependencies_siblings=$(dependencies_siblings_list 'PKG_BIN')
			;;
			('PKG_LIBS64'|'PKG_LIBS32')
				dependencies_siblings=$(dependencies_siblings_list 'PKG_LIBS')
			;;
			## TODO: The fallback value should be limited to PKG_L10N_xx identifiers, where xx is a two-letters language code.
			('PKG_L10N_'*)
				dependencies_siblings=$(dependencies_siblings_list 'PKG_L10N')
			;;
		esac
	fi

	# Fall back on the default list of dependencies for the current game engine
	if [ -z "$dependencies_siblings" ]; then
		local game_engine
		game_engine=$(game_engine)
		case "$game_engine" in
			('gamemaker')
				dependencies_siblings=$(dependencies_siblings_list_gamemaker "$package")
			;;
			('visionaire')
				dependencies_siblings=$(dependencies_siblings_list_visionaire "$package")
			;;
		esac
	fi

	printf '%s' "$dependencies_siblings" | list_clean
}

# Print native packages providing sibling packagesrequired by given package.
# USAGE: dependencies_siblings_list_packages $package
dependencies_siblings_list_packages() {
	local package
	package="$1"

	local dependencies_siblings
	dependencies_siblings=$(dependencies_siblings_list "$package")
	# Return early if current package does not require any Mono library.
	if [ -z "$dependencies_siblings" ]; then
		return 0
	fi

	local option_package
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch')
			dependencies_siblings_list_archlinux "$dependencies_siblings"
		;;
		('deb')
			dependencies_siblings_list_debian "$dependencies_siblings"
		;;
		('gentoo')
			dependencies_siblings_list_gentoo "$dependencies_siblings"
		;;
	esac
}

# Append packages to list of siblings required by given package.
# USAGE: dependencies_siblings_add $package $sibling[…]
dependencies_siblings_add() {
	local package
	package="$1"
	shift 1

	local current_siblings_variable current_siblings_list
	current_siblings_variable=$(context_name "${package}_DEPENDENCIES_SIBLINGS")
	if [ -z "$current_siblings_variable" ]; then
		current_siblings_variable="${package}_DEPENDENCIES_SIBLINGS"
	fi
	current_siblings_list=$(dependencies_siblings_list "$package")

	local sibling
	for sibling in "$@"; do
		current_siblings_list="$current_siblings_list
		$sibling"
	done

	export "${current_siblings_variable}=${current_siblings_list}"
}

