#ifndef BONNIE
#define BONNIE

using namespace std;

#define BON_VERSION "2.00"
#define CSV_VERSION "1.98"

#include "port.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

typedef FILE *PFILE;

#define SemKey 4711
#define NumSems TestCount
// 9 billion files (10) + up to 12 random extra chars
#define RandExtraLen (12)
#define MaxNameLen (10 + RandExtraLen)
// data includes index to which directory (6 bytes) and terminating '\0' for
// the name and pointer to file name
#define MaxDataPerFile (MaxNameLen + 6 + 1 + sizeof(void *))
#define MinTime (0.5)
#define DefaultSeeks (8192)
#define UpdateSeek (10)
#define DefaultSeekProcCount (5)
#define DefaultChunkBits (13)
#define DefaultChunkSize (1 << DefaultChunkBits)
#define UnitBits (20)
#define Unit (1 << UnitBits)
#define CreateNameLen 6
#define DefaultFileSize 300
#define DirectoryUnit 1024
#define DefaultDirectorySize 16
#define DefaultDirectoryMaxSize 0
#define DefaultDirectoryMinSize 0
#define DefaultByteIO 3

enum tests_t
{
  ByteWrite = 0,
  FastWrite,
  ReWrite,
  ByteRead,
  FastRead,
  Lseek,
  CreateSeq,
  StatSeq,
  DelSeq,
  CreateRand,
  StatRand,
  DelRand,
  TestCount
};

int io_error(CPCCHAR message, bool do_exit = false);
int bon_setugid(CPCCHAR user, CPCCHAR group, bool quiet);
unsigned int size_from_str(CPCCHAR str, CPCCHAR conv);

typedef enum
{
  eNoErr = 0,
  eParam = 1,
  eCtrl_C = 5
} ERROR_TYPE;

#endif
