---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, images, graphiques,
              analyse statistique, SigmaPlot, Sigma Plot
---

# Comment insérer un graphique produit avec SigmaPlot ?

[SigmaPlot](wp:SigmaPlot) est un logiciel propriétaire pour l'analyse 
de données et leur représentation graphique. Il a été très populaire 
pour la production de graphiques à insérer dans les articles scientifiques.
Il n'existe que pour Windows.

Dans certaines versions, l'exportation directe en PDF de graphiques 
de SigmaPlot ne fonctionne pas bien.


## Avec différentes méthodes d'export  

Certains utilisateurs contournent le problème en exportant leur graphique 
en EPS. Mais même dans ce cas :
- certains caractères spéciaux ne sont pas supportés ;
- la police est parfois changée.

Une solution plus robuste semble être de produire le fichier PDF 
par impression virtuelle, plutôt que par export direct. En "imprimant en PDF"
avec le pilote d'impression d'Adobe, les caractères spéciaux sont corrects. 
Il peut être nécessaire de modifier les polices avec un logiciel 
de dessin vectoriel tel qu’[Inkscape](wpfr:Inkscape) (ou Illustrator).

Une autre solution, indirecte, tient à ce que Sigmaplot insère sans problème
ses graphiques dans Word. Il est donc possible de passer par un document Word,
puis de le transformer en PDF.


## Autres pistes

Si vous êtes amateur de logiciel libre, notez qu'il existe des alternatives 
*open source* à SigmaPlot. Par exemple :

- [R](wpfr:R_(langage)), dont le fonctionnement avec LaTeX est détaillé dans 
  [une section dédiée](/4_domaines_specialises/sciences/statistiques/R/start) ;
- [SciDAVis](wp:SciDAVis) ;
- [LabPlot](wp:LabPlot) ;
- sans oublier l'extension <ctanpkg:PGFplots>, qui permet de tracer 
  la plupart des graphiques directement dans son document LaTeX, 
  sans logiciel extérieur. Elle est présentée dans différentes pages 
  de la section traitant de la 
  [visualisation de données](/3_composition/illustrations/graphiques/start).


:::{sources}
- [Sigmaplot to EPS to PDF to LaTeX](https://golatex.de/sigmaplot-to-eps-to-pdf-tp-latex-t6159.html)
  (en allemand).
- [EPS plot to LaTeX with special characters](https://tex.stackexchange.com/q/371865), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::